<?php
/*
	DevSaver web framework
	copyright (c) 2002-2018 DevSaver
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/

global $site;

class CAdminMenu{
	
	var $template; 
	var $menu;
	var $sort = true;

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function __construct() {
	}
	
	

	function Render() {
		global $base;
		global $_IS_POPUP;

		if ($_IS_POPUP) {
			return "";
		}
		
		if (is_array($this->menu)) {
					
			foreach ($this->menu as $key => $val) {

				if (is_array($val["link"])) {
					foreach ($val["link"] as $k => $v) {

						if ($v["acl"] && !$base->acl->checkRule($v["acl"] )) {
							unset($this->menu[$key]["link"][$k]);
						}							
					}						
				}

				if ($val["acl"] && !$base->acl->checkRule($val["acl"] )) {
					unset($this->menu[$key]);
				}

				if (is_array($this->menu[$key]["link"]) && !count($this->menu[$key]["link"])) {
					unset($this->menu[$key]);
				}
				
				
			}

			//preprocess for parents
			foreach ($this->menu as $key => $item) {

				if (is_array($item["link"]) && !is_array($item["link"][key($item["link"])])) {

					$item["link"] = array(
						$item["link"]
					);
				}

				if ($item["id"]) {
					$menu[$item["id"]] = $item;
				} else{
					$menu[] = $item;
				}				
			}

			$this->menu = $menu;

			foreach ($this->menu as $key => $item) {

				if ($item["parent"] && is_array($this->menu[$item["parent"]])) {

					if (!is_array($this->menu[$item["parent"]]["link"]) && isset($this->menu[$item["parent"]]["link"])) {
						$this->menu[$item["parent"]]["link"] = array(
							array(
								"title"		=> $this->menu[$item["parent"]]["title"],
								"icon"		=> $this->menu[$item["parent"]]["icon"],
								"link"		=> $this->menu[$item["parent"]]["link"],
								"subtitle"	=> $this->menu[$item["parent"]]["subtitle"],
								"protected"	=> $this->menu[$item["parent"]]["protected"],
							)
						);

					}
										
					$this->menu[$item["parent"]]["link"][] = $item;
					unset($this->menu[$key]);
				}				
			}


			//delete empty drops
			foreach ($this->menu as $key => $val) {
				if (!is_array($val["link"]) && !trim($val["link"])) {
					unset($this->menu[$key]);
				}				
			}
			
			if ($this->sort) {
				usort($this->menu, "compare_menu_item_position");
			}

			foreach ($this->menu as $key => $item) {

				$item["icon"] = $this->template->blockReplace($item["protected"] ? "IconProtected" : "Icon" , $item);

				$this->menu[$key]["selected"] = $item["selected"] = $item["selected"] && $this->template->blockExists("Selected") ? $this->template->blockReplace("Selected" , $item) : "";

				if (is_array($item["link"])) {

					//usort($item["link"], "compare_menu_item_position");


					if ($this->sort) {
						usort($item["link"], "compare_menu_item_position");
					}

					$selected = false;

					foreach ($item["link"] as $k => $v) {						

						if ($v["selected"]) {
							$selected = true;
						}						

						$item["link"][$k]["icon"] = $this->template->blockReplace($v["protected"] ? "IconProtected" : "Icon" , $v);

						if ($v["subtitle"]) {
							$item["link"][$k]["subtitle"] = $this->template->blockReplace($v["icon"] ? "SubtitleIcon" : "Subtitle" , $v);
						} else {
							$item["link"][$k]["subtitle"] = "";
						}

						$this->menu[$key]["link"][$k]["selected"] = $item["link"][$k]["selected"] = $v["selected"] && $this->template->blockExists("Selected") ? $this->template->blockReplace("Selected" , $v) : "";						
					}

					if ($selected) {
						$item["selected"] = $this->template->blockReplace("Selected");
					} else {
						$item["selected"] = "";
					}
					
					
					$this->menu[$key]["submenu"] = $items["submenu"] = $base->html->Table(
						$this->template , 
						"Links" , 
						$item["link"]
					);
					$this->menu[$key]["key"] = $key;
					$this->menu[$key]["content"] = $this->template->BlockReplace($item["protected"] ? "MenuTitleProtected" : "MenuTitle" , $item);

				} else {
					$this->menu[$key]["submenu"] = $item["submenu"] = "";

					$this->menu[$key]["content"] = $this->template->BlockReplace("MenuTitleLink" , $item);
				}
										
			}
			

			if (count($this->menu)) {

				return $this->template->blockReplacE(
					"Menu" , 
					array(
						"data"	=> $base->html->table(
							$this->template , 
							"Menu" , 
							$this->menu
						)
					)
				);
			}

			return "";
			
		}

	}
	
	

/*	
*/	
}


function compare_menu_item_position($a, $b)
{
	if ($a["prio"] == $b["prio"]) {
		return 0;
	}
	return ($a["prio"] < $b["prio"]) ? -1 : 1;
}


?>